<?php 
require 'db.php';

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['correo'])){
    $nombre = $_POST['nombre'];
    $correo = filter_var($_POST['correo'], FILTER_SANITIZE_EMAIL);
    $razon_social = $_POST['razon'];
    $tiempo = isset($_POST['tiempo_lectura']) ? intval($_POST['tiempo_lectura']) : 0;
    $ip = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'];

    $nombre = ucwords(strtolower($nombre));
    $stmt = $conn->prepare("INSERT INTO registros_manual(nombre, correo, razon, tiempo_lectura, ip, user_agent) VALUES (?,?,?,?,?,?)");
    $stmt->bind_param("sssiss", $nombre, $correo, $razon_social, $tiempo, $ip, $user_agent);

    if($stmt->execute()){
        echo "Se ha registrado la visita y lectura del manual.";
    }else{
        echo "Error al registrar: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}else{
    echo "Solicitud no válida.";
}

?>