<?php
session_start();

if (!isset($_SESSION["admin"])) {
    header("Location: login.php");
    exit();
}

function mostrarMensaje($titulo, $mensaje, $tipo = "info") {
    // Selección del ícono según el tipo
    $icono = "ℹ️";
    if ($tipo === "exito") $icono = "✅";
    elseif ($tipo === "error") $icono = "❌";

    echo '
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <title>' . htmlspecialchars($titulo) . '</title>
        <style>
            body {
                margin: 0;
                height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                background-color: #f8f9fa;
                font-family: Arial, sans-serif;
            }
            .mensaje {
                text-align: center;
                background: #fff;
                padding: 40px;
                border-radius: 12px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            .mensaje h2 {
                color: #333;
                margin-bottom: 20px;
            }
            .mensaje .icono {
                font-size: 48px;
                margin-bottom: 10px;
            }
            .mensaje a {
                display: inline-block;
                margin-top: 15px;
                text-decoration: none;
                background-color: #007bff;
                color: white;
                padding: 10px 20px;
                border-radius: 8px;
            }
            .mensaje a:hover {
                background-color: #0056b3;
            }
        </style>
    </head>
    <body>
        <div class="mensaje">
            <div class="icono">' . $icono . '</div>
            <h2>' . htmlspecialchars($titulo) . '</h2>
            <p>' . htmlspecialchars($mensaje) . '</p>
            <a href="dashboard.php">Volver</a>
        </div>
    </body>
    </html>';
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES["nuevo_pdf"])) {
    $archivo = $_FILES["nuevo_pdf"];
    if ($archivo["type"] === "application/pdf" && $archivo["size"] < 5 * 1024 * 1024) {
        move_uploaded_file($archivo["tmp_name"], "../manual.pdf");
        mostrarMensaje("PDF actualizado", "El archivo fue actualizado correctamente.", "exito");
    } else {
        mostrarMensaje("Archivo inválido", "Debe ser un archivo PDF y menor a 5MB.", "error");
    }
} else {
    mostrarMensaje("Solicitud inválida", "No se envió el archivo correctamente.", "error");
}
?>
