<?php
session_start();

if (!isset($_SESSION["admin"])) {
    header("Location: login.php");
    exit();
}

require '../db.php';

function mostrarMensaje($titulo, $mensaje, $tipo = "info") {
    $icono = "ℹ️";
    if ($tipo === "exito") $icono = "✅";
    elseif ($tipo === "error") $icono = "❌";

    echo '
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <title>' . htmlspecialchars($titulo) . '</title>
        <style>
            body {
                margin: 0;
                height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                background-color: #f8f9fa;
                font-family: Arial, sans-serif;
            }
            .mensaje {
                text-align: center;
                background: #fff;
                padding: 40px;
                border-radius: 12px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            .mensaje h2 {
                color: #333;
                margin-bottom: 20px;
            }
            .mensaje .icono {
                font-size: 48px;
                margin-bottom: 10px;
            }
            .mensaje a {
                display: inline-block;
                margin-top: 15px;
                text-decoration: none;
                background-color: #007bff;
                color: white;
                padding: 10px 20px;
                border-radius: 8px;
            }
            .mensaje a:hover {
                background-color: #0056b3;
            }
        </style>
    </head>
    <body>
        <div class="mensaje">
            <div class="icono">' . $icono . '</div>
            <h2>' . htmlspecialchars($titulo) . '</h2>
            <p>' . htmlspecialchars($mensaje) . '</p>
            <a href="dashboard.php">Volver</a>
        </div>
    </body>
    </html>';
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nuevo_user = trim($_POST['nuevo_user']);
    $nuevo_pass = password_hash($_POST['nuevo_pass'], PASSWORD_DEFAULT);

    $stmt = $conn->prepare("INSERT INTO usuarios_admin (correo, pass) VALUES (?, ?)");
    if ($stmt) {
        $stmt->bind_param("ss", $nuevo_user, $nuevo_pass);
        if ($stmt->execute()) {
            mostrarMensaje("Registro exitoso","Administrador registrado exitosamente", "exito");
        } else {
            mostrarMensaje("Registro inconcluso","El administrador no pudo ser registrado", "error");
        }
    } else {
        mostrarMensaje("Registro inconcluso","El administrador no pudo ser registrado", "error");
    }
}
?>
