<?php
session_start();
require '../db.php';

function mostrarMensaje($titulo, $mensaje, $tipo = "info") {
    $icono = "ℹ️";
    if ($tipo === "exito") $icono = "✅";
    elseif ($tipo === "error") $icono = "❌";

    echo '
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <title>' . htmlspecialchars($titulo) . '</title>
        <style>
            body {
                margin: 0;
                height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                background-color: #f8f9fa;
                font-family: Arial, sans-serif;
            }
            .mensaje {
                text-align: center;
                background: #fff;
                padding: 40px;
                border-radius: 12px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            .mensaje h2 {
                color: #333;
                margin-bottom: 20px;
            }
            .mensaje .icono {
                font-size: 48px;
                margin-bottom: 10px;
            }
            .mensaje a {
                display: inline-block;
                margin-top: 15px;
                text-decoration: none;
                background-color: #007bff;
                color: white;
                padding: 10px 20px;
                border-radius: 8px;
            }
            .mensaje a:hover {
                background-color: #0056b3;
            }
        </style>
    </head>
    <body>
        <div class="mensaje">
            <div class="icono">' . $icono . '</div>
            <h2>' . htmlspecialchars($titulo) . '</h2>
            <p>' . htmlspecialchars($mensaje) . '</p>
            <a href="dashboard.php">Volver</a>
        </div>
    </body>
    </html>';
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $correo = trim($_POST['correo']);
    $pass1 = $_POST['pass1'];

    // Buscar y actualizar
    $stmt = $conn->prepare("SELECT id FROM usuarios_admin WHERE correo = ?");
    $stmt->bind_param("s", $correo);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->close();
        $hash = password_hash($pass1, PASSWORD_DEFAULT);
        $update = $conn->prepare("UPDATE usuarios_admin SET pass = ? WHERE correo = ?");
        $update->bind_param("ss", $hash, $correo);
        $update->execute();
        mostrarMensaje("Recuperación exitosa","Contraseña recuperada exitosamente", "exito");
    } else {
        mostrarMensaje("Recuperación fallida","La contraseña no se ha podido recuperar", "error");
    }
    exit();
}