<?php
session_start();
if (!isset($_SESSION["admin"])) {
    header("Location: index.php");
    exit();
}
require '../db.php';

$result = $conn->query("SELECT * FROM registros_manual ORDER BY fecha DESC");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administrador</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
</head>
<body>

    <header class="encabezado">
        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <div class="container-fluid">
                <a class="navbar-brand"><b>Panel de Administrador</b></a>
                <div class="collapse navbar-collapse justify-content-end" id="navbarSupportedContent">
                    <ul class="navbar-nav">
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <b>Acciones</b>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" onclick="window.modal1.showModal();">Subir manual</a></li>
                                <li><a class="dropdown-item" onclick="window.modal2.showModal();">Registrar administrador</a></li>
                                <li><a class="dropdown-item" onclick="window.modal3.showModal();">Recuperar contraseña</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="logout.php">Cerrar sesión</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    </header>


    <dialog id="modal1">
        <center>
            <div style="width: 100%; text-align: center;">
                <h3>Subir nuevo manual PDF</h3>
                <form action="upload.php" method="post" enctype="multipart/form-data">
                    <input type="file" name="nuevo_pdf" accept="application/pdf" required>
                    <br>
                    <button type="submit" class="btn btn-primary" style="margin-top: 10px;"><b>Reemplazar PDF</b></button>
                </form>
            </div>
            <button class="btn btn-primary" onclick="window.modal1.close();" style="margin-top: 10px;">Cerrar</button>
        </center>
    </dialog>

    <dialog id="modal2">
        <center>
            <div style="width: 100%; display: grid; text-align: center; justify-content: center;">
                <h3>Registrar nuevo administrador</h3>
                <form action="registrar_admin.php" method="post">
                    <div class="form-floating mb-3" >
                        <input type="email" class="form-control" id="nuevo_user" name="nuevo_user" required>
                        <label for="nuevo_user">Correo de Nuevo Administrador</label>
                    </div>
                    <div class="form-floating">
                        <input type="text" class="form-control" id="nuevo_pass" name="nuevo_pass" required>
                        <label for="nuevo_pass">Password</label>
                    </div>
                    <button type="submit" class="btn btn-primary" style="margin-top: 10px;">Registrar</button>
                </form>
            </div>
            <button class="btn btn-primary" onclick="window.modal2.close();" style="margin-top: 10px;">Cerrar</button>
        </center>
    </dialog>

    <dialog id="modal3">
        <center>
            <div style="width: 100%; display: grid; text-align: center; justify-content: center;">
                <h3>Recuperar Contraseña de Administrador</h3>
                <form id="formRecuperar" method="post" action="recuperar_password.php">
                    <div class="form-floating mb-3">
                        <input type="email" class="form-control" id="correo_recuperar" name="correo" required>
                        <label for="correo_recuperar">Correo registrado</label>
                    </div>
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" id="pass1" name="pass1" required>
                        <label for="pass1">Nueva contraseña</label>
                    </div>
                    <div class="form-floating">
                        <input type="password" class="form-control" id="pass2" name="pass2" required>
                        <label for="pass2">Confirmar contraseña</label>
                    </div>
                    <div id="msgError" class="text-danger mt-2" style="display: none;"></div>
                    <button type="submit" class="btn btn-primary mt-3">Actualizar contraseña</button>
                </form>
            </div>
            <button class="btn btn-secondary mt-3" onclick="window.modal3.close();">Cerrar</button>
        </center>
    </dialog>


    <hr>
    <div style="margin: 10px;">
        <h4><b>Registros de lectura</b></h4>
        <table id="Registros" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Correo</th>
                    <th>Razón Social</th>
                    <th>Tiempo de Lectura (Segundos)</th>
                    <th>Fecha</th>
                    <!-- <th>IP</th>
                    <th>User-Agent</th> -->
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= $row['nombre']?></td>
                    <td><?= htmlspecialchars($row['correo']) ?></td>
                    <td><?= htmlspecialchars($row['razon']) ?></td>
                    <td><?= $row['tiempo_lectura'] ?></td>
                    <td><?= $row['fecha'] ?></td>
                    <!-- <td><#?= $row['ip'] ?></td>
                    <td><#?= substr($row['user_agent'], 0, 40) . "..." ?></td> -->
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <p>Sesión iniciada como <strong><?= $_SESSION["admin_user"] ?></strong></p>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

    <script>
        $(document).ready(function () {
            $('#Registros').DataTable({
                pageLength: 10,
                lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
                order: [[0, "desc"]],
                language: {
                    decimal: "",
                    emptyTable: "No hay información",
                    info: "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                    infoEmpty: "Mostrando 0 a 0 de 0 entradas",
                    infoFiltered: "(filtrado de _MAX_ entradas totales)",
                    lengthMenu: "Mostrar _MENU_ entradas",
                    loadingRecords: "Cargando...",
                    processing: "Procesando...",
                    search: "Buscar:",
                    zeroRecords: "Sin resultados encontrados",
                    paginate: {
                        first: "Primero",
                        last: "Último",
                        next: "Siguiente",
                        previous: "Anterior"
                    }
                }
            });
        });
    </script>

    <script>
        document.getElementById("formRecuperar").addEventListener("submit", function (e) {
            const pass1 = document.getElementById("pass1").value;
            const pass2 = document.getElementById("pass2").value;
            const msgError = document.getElementById("msgError");

            if (pass1 !== pass2) {
                e.preventDefault();
                msgError.style.display = "block";
                msgError.innerText = "Las contraseñas no coinciden.";
                return false;
            }

            if (pass1.length < 6) {
                e.preventDefault();
                msgError.style.display = "block";
                msgError.innerText = "La contraseña debe tener al menos 6 caracteres.";
                return false;
            }

            msgError.style.display = "none";
        });
    </script>

</body>
</html>